library(ggpubr)
library(rstatix)
library(xlsx)
library(car)

###IMPORT & FORMAT DATA###

Data.norm <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 1, header = TRUE, row.names = 1)
Data.raw <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 2, header = TRUE, row.names = 1)

lin.norm <- Data.norm[,1:16]
hull.norm <- Data.norm[,c(1,17:26)]
skin.norm <- Data.norm[,c(1,27:36)]

lin.raw <- Data.raw[,1:16]
hull.raw <- Data.raw[,c(1,17:26)]
skin.raw <- Data.raw[,c(1,27:36)]

###ANOMALOUS###

###RAW###

R_L_Thigh_out <- lin.raw[,c(1,7)]
R_L_Thigh_out <- R_L_Thigh_out[-c(1,15),]
R_L_Thigh_out_aov <- anova_test(data = R_L_Thigh_out, L_Thigh ~ Breed) 
R_L_Thigh_out_pwc <- aov(data = R_L_Thigh_out, L_Thigh ~ Breed) %>% tukey_hsd()
R_L_Thigh_out_df <- data.frame(c(R_L_Thigh_out_aov[,c(4:5,7)], R_L_Thigh_out_pwc[1,8], R_L_Thigh_out_pwc[2,8], R_L_Thigh_out_pwc[3,8]), row.names = 'R_L_Thigh_out')

R_H_Manus_out <- hull.raw[,c(1,7)]
R_H_Manus_out <- R_H_Manus_out[-c(7),]
R_H_Manus_out_aov <- anova_test(data = R_H_Manus_out, H_Manus ~ Breed) 
R_H_Manus_out_pwc <- aov(data = R_H_Manus_out, H_Manus ~ Breed) %>% tukey_hsd()
R_H_Manus_out_df <- data.frame(c(R_H_Manus_out_aov[,c(4:5,7)], R_H_Manus_out_pwc[1,8], R_H_Manus_out_pwc[2,8], R_H_Manus_out_pwc[3,8]), row.names = 'R_H_Manus_out')

R_H_Thigh_out <- hull.raw[,c(1,8)]
R_H_Thigh_out <- R_H_Thigh_out[-c(6,20,21),]
R_H_Thigh_out_aov <- anova_test(data = R_H_Thigh_out, H_Thigh ~ Breed) 
R_H_Thigh_out_pwc <- aov(data = R_H_Thigh_out, H_Thigh ~ Breed) %>% tukey_hsd()
R_H_Thigh_out_df <- data.frame(c(R_H_Thigh_out_aov[,c(4:5,7)], R_H_Thigh_out_pwc[1,8], R_H_Thigh_out_pwc[2,8], R_H_Thigh_out_pwc[3,8]), row.names = 'R_H_Thigh_out')

R_H_TMT_out <- hull.raw[,c(1,10)]
R_H_TMT_out <- R_H_TMT_out[-c(2,21),]
R_H_TMT_out_aov <- anova_test(data = R_H_TMT_out, H_TMT ~ Breed) 
R_H_TMT_out_pwc <- aov(data = R_H_TMT_out, H_TMT ~ Breed) %>% tukey_hsd()
R_H_TMT_out_df <- data.frame(c(R_H_TMT_out_aov[,c(4:5,7)], R_H_TMT_out_pwc[1,8], R_H_TMT_out_pwc[2,8], R_H_TMT_out_pwc[3,8]), row.names = 'R_H_TMT_out')

R_S_Neck_out <- skin.raw[,c(1,3)]
R_S_Neck_out <- R_S_Neck_out[-c(1,4,20),]
levene_test(data = R_S_Neck_out, S_Neck ~ Breed)
R_S_Neck_out_aov <- anova_test(data = R_S_Neck_out, S_Neck ~ Breed) 
R_S_Neck_out_pwc <- aov(data = R_S_Neck_out, S_Neck ~ Breed) %>% tukey_hsd()
R_S_Neck_out_df <- data.frame(c(R_S_Neck_out_aov[,c(4:5,7)], R_S_Neck_out_pwc[1,8], R_S_Neck_out_pwc[2,8], R_S_Neck_out_pwc[3,8]), row.names = 'R_S_Neck_out')

R_S_Torso_out <- skin.raw[,c(1,4)]
levene_test(data = R_S_Torso_out, S_Torso ~ Breed)
R_S_Torso_out_aov <- welch_anova_test(data = R_S_Torso_out, S_Torso ~ Breed) 
R_S_Torso_out_pwc <- games_howell_test(data = R_S_Torso_out, S_Torso ~ Breed)
R_S_Torso_out_df <- data.frame(c(R_S_Torso_out_aov[,c(3,6)], R_S_Torso_out_pwc[1,7], R_S_Torso_out_pwc[2,7], R_S_Torso_out_pwc[3,7]), row.names = 'R_S_Torso_out')

R_S_Manus_out <- skin.raw[,c(1,7)]
levene_test(data = R_S_Manus_out, S_Manus ~ Breed)
R_S_Manus_out_aov <- welch_anova_test(data = R_S_Manus_out, S_Manus ~ Breed) 
R_S_Manus_out_pwc <- games_howell_test(data = R_S_Manus_out, S_Manus ~ Breed)
R_S_Manus_out_df <- data.frame(c(R_S_Manus_out_aov[,c(3,6)], R_S_Manus_out_pwc[1,7], R_S_Manus_out_pwc[2,7], R_S_Manus_out_pwc[3,7]), row.names = 'R_S_Manus_out')

R_S_Thigh_out <- skin.raw[,c(1,8)]
R_S_Thigh_out <- R_S_Thigh_out[-c(20),]
levene_test(data = R_S_Thigh_out, S_Thigh ~ Breed)
R_S_Thigh_out_aov <- anova_test(data = R_S_Thigh_out, S_Thigh ~ Breed) 
R_S_Thigh_out_pwc <- aov(data = R_S_Thigh_out, S_Thigh ~ Breed) %>% tukey_hsd()
R_S_Thigh_out_df <- data.frame(c(R_S_Thigh_out_aov[,c(4:5,7)], R_S_Thigh_out_pwc[1,8], R_S_Thigh_out_pwc[2,8], R_S_Thigh_out_pwc[3,8]), row.names = 'R_S_Thigh_out')

R_S_TMT_out <- skin.raw[,c(1,10)]
levene_test(data = R_S_TMT_out, S_TMT ~ Breed)
R_S_TMT_out_aov <- welch_anova_test(data = R_S_TMT_out, S_TMT ~ Breed) 
R_S_TMT_out_pwc <- games_howell_test(data = R_S_TMT_out, S_TMT ~ Breed)
R_S_TMT_out_df <- data.frame(c(R_S_TMT_out_aov[,c(3,6)], R_S_TMT_out_pwc[1,7], R_S_TMT_out_pwc[2,7], R_S_TMT_out_pwc[3,7]), row.names = 'R_S_TMT_out')

R_S_Pes_out <- skin.raw[,c(1,11)]
R_S_Pes_out <- R_S_Pes_out[-c(2, 22),]
R_S_Pes_out_aov <- anova_test(data = R_S_Pes_out, S_Pes ~ Breed) 
R_S_Pes_out_pwc <- aov(data = R_S_Pes_out, S_Pes ~ Breed) %>% tukey_hsd()
R_S_Pes_out_df <- data.frame(c(R_S_Pes_out_aov[,c(4:5,7)], R_S_Pes_out_pwc[1,8], R_S_Pes_out_pwc[2,8], R_S_Pes_out_pwc[3,8]), row.names = 'R_S_Pes_out')

###Format Raw AOV Results###
R_List <- do.call("rbind", list(
  R_L_Thigh_out_df, R_H_Manus_out_df, R_H_Thigh_out_df, R_H_TMT_out_df,
  R_S_Neck_out_df, R_S_Thigh_out_df, R_S_Pes_out_df))

R_W_List <- do.call("rbind", list(
  R_S_Torso_out_df, R_S_Manus_out_df, R_S_TMT_out_df))


###NORMALISED###

N_L_Humerus_out <- lin.norm[,c(1:2)]
N_L_Humerus_out <- N_L_Humerus_out[-c(10),]
N_L_Humerus_out_aov <- anova_test(data = N_L_Humerus_out, L_Humerus ~ Breed) 
N_L_Humerus_out_pwc <- aov(data = N_L_Humerus_out, L_Humerus ~ Breed) %>% tukey_hsd()
N_L_Humerus_out_df <- data.frame(c(N_L_Humerus_out_aov[,c(4:5,7)], N_L_Humerus_out_pwc[1,8], N_L_Humerus_out_pwc[2,8], N_L_Humerus_out_pwc[3,8]), row.names = 'N_L_Humerus_out')

N_L_TotalHind_out <- lin.norm[,c(1,11)]
levene_test(data = N_L_TotalHind_out, L_TotalHind ~ Breed)
N_L_TotalHind_out_aov <- welch_anova_test(data = N_L_TotalHind_out, L_TotalHind ~ Breed) 
N_L_TotalHind_out_pwc <- games_howell_test(data = N_L_TotalHind_out, L_TotalHind ~ Breed)
N_L_TotalHind_out_df <- data.frame(c(N_L_TotalHind_out_aov[,c(3,6)], N_L_TotalHind_out_pwc[1,7], N_L_TotalHind_out_pwc[2,7], N_L_TotalHind_out_pwc[3,7]), row.names = 'N_L_TotalHind_out')

N_L_Neck_out <- lin.norm[,c(1,12)]
levene_test(data = N_L_Neck_out, L_Neck ~ Breed)
N_L_Neck_out_aov <- welch_anova_test(data = N_L_Neck_out, L_Neck ~ Breed) 
N_L_Neck_out_pwc <- games_howell_test(data = N_L_Neck_out, L_Neck ~ Breed)
N_L_Neck_out_df <- data.frame(c(N_L_Neck_out_aov[,c(3,6)], N_L_Neck_out_pwc[1,7], N_L_Neck_out_pwc[2,7], N_L_Neck_out_pwc[3,7]), row.names = 'N_L_Neck_out')

N_L_Shoulder_out <- lin.norm[,c(1,13)]
N_L_Shoulder_out <- N_L_Shoulder_out[-c(13),]
N_L_Shoulder_out_aov <- anova_test(data = N_L_Shoulder_out, L_Shoulder ~ Breed) 
N_L_Shoulder_out_pwc <- aov(data = N_L_Shoulder_out, L_Shoulder ~ Breed) %>% tukey_hsd()
N_L_Shoulder_out_df <- data.frame(c(N_L_Shoulder_out_aov[,c(4:5,7)], N_L_Shoulder_out_pwc[1,8], N_L_Shoulder_out_pwc[2,8], N_L_Shoulder_out_pwc[3,8]), row.names = 'N_L_Shoulder_out')

N_L_GA_out <- lin.norm[,c(1,15)]
N_L_GA_out <- N_L_GA_out[-c(21:22),]
N_L_GA_out_aov <- anova_test(data = N_L_GA_out, L_GA ~ Breed) 
N_L_GA_out_pwc <- aov(data = N_L_GA_out, L_GA ~ Breed) %>% tukey_hsd()
N_L_GA_out_df <- data.frame(c(N_L_GA_out_aov[,c(4:5,7)], N_L_GA_out_pwc[1,8], N_L_GA_out_pwc[2,8], N_L_GA_out_pwc[3,8]), row.names = 'N_L_GA_out')

N_H_Head_out <- hull.norm[,c(1:2)]
N_H_Head_out <- N_H_Head_out[-c(7,12),]
N_H_Head_out_aov <- anova_test(data = N_H_Head_out, H_Head ~ Breed) 
N_H_Head_out_pwc <- aov(data = N_H_Head_out, H_Head ~ Breed) %>% tukey_hsd()
N_H_Head_out_df <- data.frame(c(N_H_Head_out_aov[,c(4:5,7)], N_H_Head_out_pwc[1,8], N_H_Head_out_pwc[2,8], N_H_Head_out_pwc[3,8]), row.names = 'N_H_Head_out')

N_H_Neck_out <- hull.norm[,c(1,3)]
N_H_Neck_out <- N_H_Neck_out[-c(16:17),]
N_H_Neck_out_aov <- anova_test(data = N_H_Neck_out, H_Neck ~ Breed) 
N_H_Neck_out_pwc <- aov(data = N_H_Neck_out, H_Neck ~ Breed) %>% tukey_hsd()
N_H_Neck_out_df <- data.frame(c(N_H_Neck_out_aov[,c(4:5,7)], N_H_Neck_out_pwc[1,8], N_H_Neck_out_pwc[2,8], N_H_Neck_out_pwc[3,8]), row.names = 'N_H_Neck_out')

N_S_Humerus_out <- skin.norm[,c(1,5)]
N_S_Humerus_out <- N_S_Humerus_out[-c(11),]
N_S_Humerus_out_aov <- anova_test(data = N_S_Humerus_out, S_Humerus ~ Breed) 
N_S_Humerus_out_pwc <- aov(data = N_S_Humerus_out, S_Humerus ~ Breed) %>% tukey_hsd()
N_S_Humerus_out_df <- data.frame(c(N_S_Humerus_out_aov[,c(4:5,7)], N_S_Humerus_out_pwc[1,8], N_S_Humerus_out_pwc[2,8], N_S_Humerus_out_pwc[3,8]), row.names = 'N_S_Humerus_out')

N_S_Forearm_out <- skin.norm[,c(1,6)]
N_S_Forearm_out <- N_S_Forearm_out[-c(19),]
N_S_Forearm_out_aov <- anova_test(data = N_S_Forearm_out, S_Forearm ~ Breed) 
N_S_Forearm_out_pwc <- aov(data = N_S_Forearm_out, S_Forearm ~ Breed) %>% tukey_hsd()
N_S_Forearm_out_df <- data.frame(c(N_S_Forearm_out_aov[,c(4:5,7)], N_S_Forearm_out_pwc[1,8], N_S_Forearm_out_pwc[2,8], N_S_Forearm_out_pwc[3,8]), row.names = 'N_S_Forearm_out')

N_S_Pes_out <- skin.norm[,c(1,11)]
N_S_Pes_out <- N_S_Pes_out[-c(2),]
N_S_Pes_out_aov <- anova_test(data = N_S_Pes_out, S_Pes ~ Breed) 
N_S_Pes_out_pwc <- aov(data = N_S_Pes_out, S_Pes ~ Breed) %>% tukey_hsd()
N_S_Pes_out_df <- data.frame(c(N_S_Pes_out_aov[,c(4:5,7)], N_S_Pes_out_pwc[1,8], N_S_Pes_out_pwc[2,8], N_S_Pes_out_pwc[3,8]), row.names = 'N_S_Pes_out')

###Format Normalised AOV Results###
N_List <- do.call("rbind", list(
  N_L_Humerus_out_df, N_L_Shoulder_out_df, N_L_GA_out_df,N_H_Head_out_df,
  N_H_Neck_out_df, N_S_Humerus_out_df, N_S_Forearm_out_df, N_S_Pes_out_df))

N_W_List <- do.call("rbind", list(
  N_L_TotalHind_out_df, N_L_Neck_out_df))

###Export AOV Results###

write.xlsx(R_List, file = 'AOV_Checks.xlsx', sheetName = 'Raw')
write.xlsx(R_W_List, file = 'AOV_Checks.xlsx', sheetName = 'Raw_Welch', append = TRUE)
write.xlsx(N_List, file = 'AOV_Checks.xlsx', sheetName = 'Norm', append = TRUE)
write.xlsx(N_W_List, file = 'AOV_Checks.xlsx', sheetName = 'Norm_Welch', append = TRUE)